// Quiz dynamic rendering and navigation

const renderQuiz = () => {
    const rightColumn =
        document.querySelector('.quiz-box .row.pt-4.align-items-center > div:last-child') ||
        document.querySelector('.quiz-box');
    if (!rightColumn) return;

    // hide static questions if present
    document.querySelectorAll('.questao').forEach(el => (el.style.display = 'none'));

    let root = document.querySelector('#quiz-root');
    if (!root) {
        root = document.createElement('div');
        root.id = 'quiz-root';
        rightColumn.prepend(root);
    }
    root.innerHTML = '';

    // intro
    const introDiv = document.createElement('div');
    introDiv.className = 'quiz-box__intro-content';
         introDiv.innerHTML = '<div id="texto-introducao" class="quiz-intro"><span class="quiz-intro__typewriter"></span></div>';
    root.appendChild(introDiv);

    // questions
    const questionsWrapper = document.createElement('div');
    questionsWrapper.className = 'quiz-questions-wrapper';

    quizConfig.questions.forEach((q, idx) => {
        const questionIdx = idx + 1;
        const container = document.createElement('div');
        container.className = 'quiz-question';
        container.id = `question-${questionIdx}`;
        if (idx !== 0) container.style.display = 'none';

        const titleHtml = `<div class="quiz-box__question-title-content"><h3 class="quiz-box__question-number"><span style="font-weight: 700; font-size: 18px">Pergunta ${questionIdx}.</span></h3><h3>${q.question}</h3></div>`;
        const optionsHtml = q.answers
            .map(
                a =>
                    `<button 
                        class="quiz-options__item" 
                        data-next="${questionIdx + 1}"
                    >${a}</button>`
            )
            .join('');
        container.innerHTML = `${titleHtml}<div class="quiz-box__options-content"><div class="quiz-options">${optionsHtml}</div></div>`;

        questionsWrapper.appendChild(container);
    });

    root.appendChild(questionsWrapper);

    // final step
    const finalStepIdx = quizConfig.questions.length + 1;
    const finalDiv = document.createElement('div');
    finalDiv.className = 'quiz-final';
    finalDiv.id = `question-${finalStepIdx}`;
    finalDiv.style.display = 'none';
    finalDiv.innerHTML = `
		<div class="quiz-box__question-title-content">
			<div class="quiz-final__text">
				<p>
					En réalité, c’est simplement l’un des signaux auxquels votre corps peut vous alerter.<br><br>
					C’est aussi l’un de ceux qui réagissent le plus facilement à de petits changements naturels au quotidien.<br><br>
				C’est pourquoi je suis heureuse de vous dire que vous êtes parfaitement prête à regarder cette présentation exclusive.<br><br>
					Mais je ne peux vous donner l’accès que si vous vous engagez à la regarder jusqu’au bout.
				</p>
			</div>
		</div>
		<div class="quiz-box__options-content">
			<div class="quiz-options">
                <a class="quiz-options__item quiz-options__item--green" href="${quizConfig.links.assistir}">Oui, je vais regarder jusqu’à la fin et prendre soin de mon bien-être naturellement.</a>
 
				<a class="quiz-options__item quiz-options__item--gray" href="${quizConfig.links.naoAssistir}">Non, merci.<br>Je suis satisfaite de mon bien-être actuel.</a>
			</div>
		</div>
	`;

    root.appendChild(finalDiv);
};

const setupQuizNavigation = () => {
    let currentQuestion = 1;
    const totalSteps = quizConfig.questions.length + 1;

         document.querySelectorAll('.quiz-options__item').forEach(option => {
         option.addEventListener('click', function () {
             const nextQuestion = parseInt(this.getAttribute('data-next'));
             if (!nextQuestion) return;
 
             // Hide intro content after first question
             if (currentQuestion === 1) {
                 const introContent = document.querySelector('.quiz-box__intro-content');
                 if (introContent) introContent.style.display = 'none';
             }
 
             const currentEl = document.querySelector(`#question-${currentQuestion}`);
             const nextEl = document.querySelector(`#question-${nextQuestion}`);
 
             if (currentEl && nextEl) {
                 currentEl.style.display = 'none';
                 nextEl.style.display = 'block';
                 currentQuestion = nextQuestion;
                 updateProgressBar(currentQuestion, totalSteps);
             }
         });
     });
};

const updateProgressBar = (step, totalSteps) => {
    const newWidth = (step / totalSteps) * 99.3;
    const bar = document.querySelector('.quiz-progress__bar');
    if (bar) bar.style.width = `${newWidth}%`;
};

document.addEventListener('DOMContentLoaded', () => {
    renderQuiz();
    setupQuizNavigation();
    if (window.typeWriter) typeWriter();
    updateProgressBar(1, quizConfig.questions.length + 1);
});
